FasdUAS 1.101.10        
  k           
  l           
 * AccordanceFlashcards is a script application that will take a search string, submit it to
 * Accordance using the supplied Flashcards workspace, and then post-process the analysis output
 * to produce a tab delimited file for upload to a flashcard site such as cram.com.
 *
 * Accordance version : 10.3.4, specifically the on which has support for saving analysis tab
 *                          results in Plain Text form.
 *
 * Usage :
 *
 * AccordanceFlashcards may be launched as a regular application by double clicking on it.
 * Before doing so ensure that the Flashcards workspace is open in Accordance and that the
 * GNT28-T search tab is selected.
 *
 * Once you have entered your query and the script comes back asking you to save the
 * output to a file enter a file name to save to. Once you have that file you can open it
 * in TextEdit and copy and paste into a flashcard site like cram.com.
 *
 * For additional issues such as export preference and accessibility privileges
 * see notes below.
 *
 * Accordance preferences :
 *
 *     Preferences -> Export -> Export all characters in Unicode should be set.
 *
 * Generally, in order to ensure the stability of the analysis output, and thus
 * that it conforms to expected format, the searches should of the form:
 *
 *               [count x-y] <AND> [range bla]
 *
 * Results may be unpredictable for other forms. The basic problem will be
 * the post-processing of the analysis data. If you have cases of interest
 * let me know. It ought to be possible to handle them with some changes.
 *
 * OSX Issues:
 *
 * Ensure that the script is granted assistive access. It will fail when first run
 * and you can then enable the access via System Preferences -> Security and Privacy
 * by checking the box for this application. This URL : http://support.apple.com/kb/HT6026
 * explains the procedure.
 *
 * Copyright Daniel Semler Jan 2014.
 *
 * Revised
 *
 * 6 Apr 2014 : documented enabling assistive access
 *                     fix accompanying workspace to have no saved search
       	 	
 
   *   A c c o r d a n c e F l a s h c a r d s   i s   a   s c r i p t   a p p l i c a t i o n   t h a t   w i l l   t a k e   a   s e a r c h   s t r i n g ,   s u b m i t   i t   t o 
   *   A c c o r d a n c e   u s i n g   t h e   s u p p l i e d   F l a s h c a r d s   w o r k s p a c e ,   a n d   t h e n   p o s t - p r o c e s s   t h e   a n a l y s i s   o u t p u t 
   *   t o   p r o d u c e   a   t a b   d e l i m i t e d   f i l e   f o r   u p l o a d   t o   a   f l a s h c a r d   s i t e   s u c h   a s   c r a m . c o m . 
   * 
   *   A c c o r d a n c e   v e r s i o n   :   1 0 . 3 . 4 ,   s p e c i f i c a l l y   t h e   o n   w h i c h   h a s   s u p p o r t   f o r   s a v i n g   a n a l y s i s   t a b 
   *                                                     r e s u l t s   i n   P l a i n   T e x t   f o r m . 
   * 
   *   U s a g e   : 
   * 
   *   A c c o r d a n c e F l a s h c a r d s   m a y   b e   l a u n c h e d   a s   a   r e g u l a r   a p p l i c a t i o n   b y   d o u b l e   c l i c k i n g   o n   i t . 
   *   B e f o r e   d o i n g   s o   e n s u r e   t h a t   t h e   F l a s h c a r d s   w o r k s p a c e   i s   o p e n   i n   A c c o r d a n c e   a n d   t h a t   t h e 
   *   G N T 2 8 - T   s e a r c h   t a b   i s   s e l e c t e d . 
   * 
   *   O n c e   y o u   h a v e   e n t e r e d   y o u r   q u e r y   a n d   t h e   s c r i p t   c o m e s   b a c k   a s k i n g   y o u   t o   s a v e   t h e 
   *   o u t p u t   t o   a   f i l e   e n t e r   a   f i l e   n a m e   t o   s a v e   t o .   O n c e   y o u   h a v e   t h a t   f i l e   y o u   c a n   o p e n   i t 
   *   i n   T e x t E d i t   a n d   c o p y   a n d   p a s t e   i n t o   a   f l a s h c a r d   s i t e   l i k e   c r a m . c o m . 
   * 
   *   F o r   a d d i t i o n a l   i s s u e s   s u c h   a s   e x p o r t   p r e f e r e n c e   a n d   a c c e s s i b i l i t y   p r i v i l e g e s 
   *   s e e   n o t e s   b e l o w . 
   * 
   *   A c c o r d a n c e   p r e f e r e n c e s   : 
   * 
   *           P r e f e r e n c e s   - >   E x p o r t   - >   E x p o r t   a l l   c h a r a c t e r s   i n   U n i c o d e   s h o u l d   b e   s e t . 
   * 
   *   G e n e r a l l y ,   i n   o r d e r   t o   e n s u r e   t h e   s t a b i l i t y   o f   t h e   a n a l y s i s   o u t p u t ,   a n d   t h u s 
   *   t h a t   i t   c o n f o r m s   t o   e x p e c t e d   f o r m a t ,   t h e   s e a r c h e s   s h o u l d   o f   t h e   f o r m : 
   * 
   *                               [ c o u n t   x - y ]   < A N D >   [ r a n g e   b l a ] 
   * 
   *   R e s u l t s   m a y   b e   u n p r e d i c t a b l e   f o r   o t h e r   f o r m s .   T h e   b a s i c   p r o b l e m   w i l l   b e 
   *   t h e   p o s t - p r o c e s s i n g   o f   t h e   a n a l y s i s   d a t a .   I f   y o u   h a v e   c a s e s   o f   i n t e r e s t 
   *   l e t   m e   k n o w .   I t   o u g h t   t o   b e   p o s s i b l e   t o   h a n d l e   t h e m   w i t h   s o m e   c h a n g e s . 
   * 
   *   O S X   I s s u e s : 
   * 
   *   E n s u r e   t h a t   t h e   s c r i p t   i s   g r a n t e d   a s s i s t i v e   a c c e s s .   I t   w i l l   f a i l   w h e n   f i r s t   r u n 
   *   a n d   y o u   c a n   t h e n   e n a b l e   t h e   a c c e s s   v i a   S y s t e m   P r e f e r e n c e s   - >   S e c u r i t y   a n d   P r i v a c y 
   *   b y   c h e c k i n g   t h e   b o x   f o r   t h i s   a p p l i c a t i o n .   T h i s   U R L   :   h t t p : / / s u p p o r t . a p p l e . c o m / k b / H T 6 0 2 6 
   *   e x p l a i n s   t h e   p r o c e d u r e . 
   * 
   *   C o p y r i g h t   D a n i e l   S e m l e r   J a n   2 0 1 4 . 
   * 
   *   R e v i s e d 
   * 
   *   6   A p r   2 0 1 4   :   d o c u m e n t e d   e n a b l i n g   a s s i s t i v e   a c c e s s 
   *                                           f i x   a c c o m p a n y i n g   w o r k s p a c e   t o   h a v e   n o   s a v e d   s e a r c h 
     
 
 
 j       *0 defaultsearchstring defaultSearchString
  m      
 
    < [ c o u n t   1 - 5 0 ]   < A N D >   [ r a n g e   e p h ]    
  j      ,0 analysistempfilename analysisTempFileName
  m            a n a l y s i s T e m p F i l e    
  l        
  j      0 d  
  m       ?          basic delay value        $   b a s i c   d e l a y   v a l u e    
  l               
  l        !     
  FIXMEs    !  " "    F I X M E s   # $
 # l      % &   %    99. Get rid of all FIXMEs    &  ' ' 4   9 9 .   G e t   r i d   o f   a l l   F I X M E s $  ( )
 ( l            )  * +
 * l       , -   , b \
 * AccordanceFlashcards uses the following error numbers defined in the error properties.
     -  . .  
   *   A c c o r d a n c e F l a s h c a r d s   u s e s   t h e   f o l l o w i n g   e r r o r   n u m b e r s   d e f i n e d   i n   t h e   e r r o r   p r o p e r t i e s . 
   +  / 0
 / j   	  1 .0 nosearchstring_errnum NoSearchString_ErrNum
 1 m   	 
 0  2 3
 2 j     4 .0 nosearchstring_errmsg NoSearchString_ErrMsg
 4 m    
 5 5  6 6  N o   s e a r c h   s t r i n g   w a s   p r o v i d e d .   P l e a s e   e n t e r   a   v a l i d   A c c o r d a n c e   s e a r c h   s t r i n g   t o   d e f i n e   y o u r   f l a s h c a r d s 3  7 8
 7 j     9 .0 noflashcardsws_errnum NoFlashcardsWS_ErrNum
 9 m     8  : ;
 : j     < .0 noflashcardsws_errmsg NoFlashcardsWS_ErrMsg
 < m     = =  > >  T h e   F l a s h c a r d s   w o r k s p a c e   i s   n o t   o p e n .   P l e a s e   o p e n   t h e   F l a s h c a r d s   w o r k s p a c e   a n d   e n s u r e   t h e   s e a r c h   p a n e   i s   s e l e c t e d ;  ? @
 ? j     A 60 couldnotdeletefile_errnum CouldNotDeleteFile_ErrNum
 A m     @  B C
 B j     D 60 couldnotdeletefile_errmsg CouldNotDeleteFile_ErrMsg
 D m     E E  F F 0 C o u l d   n o t   d e l e t e   f i l e   :   C  G H
 G l            H  I J
 I l       K L   K ) #
 * Main entry point run handler.
     L  M M F 
   *   M a i n   e n t r y   p o i n t   r u n   h a n d l e r . 
   J  N O
 N i      P Q
 P I      R
 .aevtoappnull      ****
 R J          
 Q k     f S S  T U
 T l      V W   V 0 * Get the searchString query for Accordance    W  X X T   G e t   t h e   s e a r c h S t r i n g   q u e r y   f o r   A c c o r d a n c e U  Y Z
 Y r      [ \
 [ I      "0 getsearchstring getSearchString    
 \ o       0 searchstring searchString Z  ] ^
 ] l          ^  _
 _ Q    f ` a b
 ` k    # c c  d e
 d l    f g   f   Activate Accordance    g  h h (   A c t i v a t e   A c c o r d a n c e e  i j
 i O     k l
 k I   
 .miscactvnull  null    
 l m     m m                                                                                  ACC0  alis    ^  Macintosh HD               +]H+  {/Accordance.app                                                 *w[=          	                Applications    +      [    {/  )Macintosh HD:Applications: Accordance.app     A c c o r d a n c e . a p p    M a c i n t o s h   H D  Applications/Accordance.app   /    j  n o
 n l          o  p q
 p l    r s   r   Create the flashcards    s  t t ,   C r e a t e   t h e   f l a s h c a r d s q  u v
 u I    ! w $0 createflashcards createFlashCards w  x y
 x I     0 getprocname getProcName     y  z
 z o     0 searchstring searchString     v  {
 { l  " "        
 a R       | }
 .ascrerr ****       ****
 | o       0 errmsg errMsg }  ~
 
errn
 ~ o       0 errnum errNum  
 b k   + f     
  O  + 5  
  I  / 4
 .miscactvnull  null    
   f   + ,   
  Z   6 f    
  =   6 9  
  o   6 7 0 errnum errNum
  m   7 8
  k   < C     
  l  < <      2 , general user cancellation from a dialog box        X   g e n e r a l   u s e r   c a n c e l l a t i o n   f r o m   a   d i a l o g   b o x   
  I  < C  
 .sysodlogaskr        TEXT
  l  < = 
  m   < =      0 U s e r   c a n c e l l e d   o p e r a t i o n       
 
appr
  m   > ?      ( A c c o r d a n c e F l a s h c a r d s        
  =   F I  
  o   F G 0 errnum errNum
  m   G HI   
  k   L R     
  l  L L      M G rethrow this as there is an OS handler for the assitive security error           r e t h r o w   t h i s   a s   t h e r e   i s   a n   O S   h a n d l e r   f o r   t h e   a s s i t i v e   s e c u r i t y   e r r o r   
  R   L R  
 .ascrerr ****       ****
  o   P Q 0 errmsg errMsg   
 
errn
  o   N O 0 errnum errNum      
  k   U f     
  l  U U      < 6 currently both AccordanceFlashcards errors and others        l   c u r r e n t l y   b o t h   A c c o r d a n c e F l a s h c a r d s   e r r o r s   a n d   o t h e r s   
  I  U f  
 .sysodlogaskr        TEXT
  l  U ^ 
  b   U ^  
  b   U \  
  b   U X  
  m   U V       E r r o r  
  o   V W 0 errnum errNum
  m   X [       ,  
  o   \ ] 0 errmsg errMsg       
 
appr
  m   _ b      ( A c c o r d a n c e F l a s h c a r d s         O   
  l               
  l             
 * Get a non-empty search string for Accordance query.
 * Note that getSearchString does not validate the query in anyway except to
 * handle the empty string and cancellation cases.
 * 
 * Returns : the search string as a string
         
   *   G e t   a   n o n - e m p t y   s e a r c h   s t r i n g   f o r   A c c o r d a n c e   q u e r y . 
   *   N o t e   t h a t   g e t S e a r c h S t r i n g   d o e s   n o t   v a l i d a t e   t h e   q u e r y   i n   a n y w a y   e x c e p t   t o 
   *   h a n d l e   t h e   e m p t y   s t r i n g   a n d   c a n c e l l a t i o n   c a s e s . 
   *   
   *   R e t u r n s   :   t h e   s e a r c h   s t r i n g   a s   a   s t r i n g 
      
  i   ! $  
  I       "0 getsearchstring getSearchString    
  k     =     
  r       
  l    
 
  I    
  
 .sysodlogaskr        TEXT
  m           & E n t e r   s e a r c h   s t r i n g    
 
dtxt
  o     *0 defaultsearchstring defaultSearchString   
 
appr
  m    	      ( A c c o r d a n c e F l a s h c a r d s      
  o       0 reqsearchstr reqSearchStr   
  Z    =  
  =     
  n      
  1    
 
bhit
  o     0 reqsearchstr reqSearchStr
  m           O K
  k    9     
  r      
  n      
  1    
 
ttxt
  o     0 reqsearchstr reqSearchStr
  o       0 srch      
  Z    6  
  =   !  
  o     0 srch  
  m            
  R   $ 2  
 .ascrerr ****       ****
  o   , 1 .0 nosearchstring_errmsg NoSearchString_ErrMsg   
 
errn
  o   & + .0 nosearchstring_errnum NoSearchString_ErrNum          
  l  7 7         ~
  L   7 9 
  o   7 8}} 0 srch  ~            
  l     |{z|  {  z      
  l      y  y    y s
 * Create the flashcards data
 * This is a driver handler which controls the various subtasks that are required.
          
   *   C r e a t e   t h e   f l a s h c a r d s   d a t a 
   *   T h i s   i s   a   d r i v e r   h a n d l e r   w h i c h   c o n t r o l s   t h e   v a r i o u s   s u b t a s k s   t h a t   a r e   r e q u i r e d . 
     
  i   % (
 I      xwx $0 createflashcards createFlashCards 
 o      vv 0 
accordprocess 
accordProcess u
 o      tt 0 	searchfor 	searchForu  w  
 k     v 	

	 l     srqs  r  q  
 
 l     p
p  
 O I First find the existing open Flashcards WS or prompt the user to open it        F i r s t   f i n d   t h e   e x i s t i n g   o p e n   F l a s h c a r d s   W S   o r   p r o m p t   t h e   u s e r   t o   o p e n   i t 
 I     ono $0 findflashcardsws findFlashcardsWS m
 o    ll 0 
accordprocess 
accordProcessm  n   
 l   kjik  j  i   
 l   hh   6 0 Get the search analysis results from Accordance     `   G e t   t h e   s e a r c h   a n a l y s i s   r e s u l t s   f r o m   A c c o r d a n c e 
 I    gfg *0 runaccordancesearch runAccordanceSearch 
 o    	ee 0 
accordprocess 
accordProcess  d
  o   	 
cc 0 	searchfor 	searchFord  f   !"
! l   ba`b  a  `  " #$
# l   _%&_  % D > Add a small delay to ensure temp file operations have stopped   & '' |   A d d   a   s m a l l   d e l a y   t o   e n s u r e   t e m p   f i l e   o p e r a t i o n s   h a v e   s t o p p e d$ ()
( l   ^*+^  * I C Accordance can take a little bit of time to get the temporary file   + ,,    A c c o r d a n c e   c a n   t a k e   a   l i t t l e   b i t   o f   t i m e   t o   g e t   t h e   t e m p o r a r y   f i l e) -.
- l   ]/0]  /   onto disk.   0 11    o n t o   d i s k .. 23
2 l   \45\  4 ) # FIXME - how can we know its done ?   5 66 F   F I X M E   -   h o w   c a n   w e   k n o w   i t s   d o n e   ?3 78
7 I    [9Z[ 0 dodelay doDelay9 :Y
: m    XX Y  Z  8 ;<
; I   W=V
W .miscactvnull  null
=  f    V  < >?
> l   UTSU  T  S  ? @A
@ l   RBCR  B 0 * cleanup the string and write it to a file   C DD T   c l e a n u p   t h e   s t r i n g   a n d   w r i t e   i t   t o   a   f i l eA EF
E r    2GH
G I    0QIPQ 0 converttotsv convertToTSVI JO
J c    ,KL
K l   *MNM
M b    *NO
N b    (PQ
P l   "RLK
R I   "JSI
J .earsffdralis        afdr
S m    H
H afdrtempI  L  K  
Q o   " 'GG ,0 analysistempfilename analysisTempFileName
O m   ( )TT UU  . t x tN  M  
L m   * +F
F 
ctxtO  P  
H o      EE 0 tsvstr tsvStrF VW
V r   3 <XY
X I  3 :DCZ
D .sysonwflfile     nullC  Z B[A
B 
prmt
[ m   5 6\\ ]] 8 S a v e   t a b   d e l i m i t e d   f i l e   t o   :A  
Y o      @@ 0 tsvfile tsvFileW ^_
^ r   = F`a
` I  = D?bc
? .rdwropenshor       file
b o   = >>> 0 tsvfile tsvFilec =d<
= 
perm
d m   ? @;
; boovtrue<  
a o      :: 0 tf  _ ef
e Q   G nghi
g I  J W9jk
9 .rdwrwritnull     ****
j o   J K88 0 tsvstr tsvStrk 7lm
7 
refn
l o   L M66 0 tf  m 5n4
5 
as  
n m   N Q3
3 
utf84  
h R      2op
2 .ascrerr ****       ****
o o      11 0 errmsg errMsgp 0q/
0 
errn
q o      .. 0 errnum errNum/  
i I  _ n-r,
- .ascrcmnt****       ****
r b   _ jst
s b   _ huv
u b   _ dwx
w m   _ byy zz  G o t   e r r o r :  
x o   b c++ 0 errnum errNum
v m   d g{{ ||  .  
t o   h i** 0 errmsg errMsg,  f }~
} I  o t)(
) .rdwrclosnull     ****
 o   o p'' 0 tf  (  ~ &
 l  u u%$#%  $  #  &   
 l     "! "  !      
 l          
  Get the Flashcards workspace to the front.
  This handler will either succeed in bringing the WS to the front or throw an
  error.
  
  Returns : VOID
     6 
     G e t   t h e   F l a s h c a r d s   w o r k s p a c e   t o   t h e   f r o n t . 
     T h i s   h a n d l e r   w i l l   e i t h e r   s u c c e e d   i n   b r i n g i n g   t h e   W S   t o   t h e   f r o n t   o r   t h r o w   a n 
     e r r o r . 
     
     R e t u r n s   :   V O I D 
   
 i   ) ,
 I       $0 findflashcardsws findFlashcardsWS 
 o       0 
accordprocess 
accordProcess    
 k     L 
 l        0 * Get Flashcards workspace window in front.     T   G e t   F l a s h c a r d s   w o r k s p a c e   w i n d o w   i n   f r o n t . 
 O     L
 O    K
 Q    J
 k    # 
 r    
 n    
 4    
 
menI
 m       F l a s h c a r d s
 n    
 4    
 
menE
 m     
 n    
 4    
 
mbri
 m       W i n d o w
 4    
 
mbar
 m   
  
 o       0 fcards fCards 
 I    
 .prcsclicnull  uiel
 o     0 fcards fCards   
 L   ! #

    
 R      
 .ascrerr ****       ****
 o       0 errmsg errMsg 
	

 
errn
 o       0 errnum errNum	  
 k   + J 
 Z   + C
 =   + .
 o   + , 0 errnum errNum
 m   , -@
 R   1 ?
 .ascrerr ****       ****
 o   9 > .0 noflashcardsws_errmsg NoFlashcardsWS_ErrMsg  
 
errn
 o   3 8 .0 noflashcardsws_errnum NoFlashcardsWS_ErrNum        
 R   D J
 .ascrerr ****       ****
 o   H I 0 errmsg errMsg 
 
errn
 o   F G 0 errnum errNum    
 o     0 
accordprocess 
accordProcess
 m                                                                                       sevs  alis      Macintosh HD               +]H+  {.System Events.app                                              ~A`          	                CoreServices    +      A9    {.{.{.  =Macintosh HD:System: Library: CoreServices: System Events.app   $  S y s t e m   E v e n t s . a p p    M a c i n t o s h   H D  -System/Library/CoreServices/System Events.app   /      
 l            
 l          
  Get Accordance to run the search and then put the analysis results into
  the pasteboard.
  This handler assumes that the front most workspace is the Flashcards WS.
  Returns : VOID
     t 
     G e t   A c c o r d a n c e   t o   r u n   t h e   s e a r c h   a n d   t h e n   p u t   t h e   a n a l y s i s   r e s u l t s   i n t o 
     t h e   p a s t e b o a r d . 
     T h i s   h a n d l e r   a s s u m e s   t h a t   t h e   f r o n t   m o s t   w o r k s p a c e   i s   t h e   F l a s h c a r d s   W S . 
     R e t u r n s   :   V O I D 
   
 i   - 0
 I       *0 runaccordancesearch runAccordanceSearch 
 o       0 
accordprocess 
accordProcess 
 o       0 	searchfor 	searchFor    
 k      
 O     o
 O    n
 k    m 
 l      - ' Cycle to words field and then verses,      N   C y c l e   t o   w o r d s   f i e l d   a n d   t h e n   v e r s e s ,   
 l      A ; for the purpose of ensuring the search box is highlighted.     v   f o r   t h e   p u r p o s e   o f   e n s u r i n g   t h e   s e a r c h   b o x   i s   h i g h l i g h t e d . 
 l          
 l      U O The reason we want verse search even though we are doing a word search is that        T h e   r e a s o n   w e   w a n t   v e r s e   s e a r c h   e v e n   t h o u g h   w e   a r e   d o i n g   a   w o r d   s e a r c h   i s   t h a t 
 l      X R a verse search in an original language text is entered in English, whereas a word        a   v e r s e   s e a r c h   i n   a n   o r i g i n a l   l a n g u a g e   t e x t   i s   e n t e r e d   i n   E n g l i s h ,   w h e r e a s   a   w o r d 
 l      X R search is entered in the original language which in this case leads to the pop up        s e a r c h   i s   e n t e r e d   i n   t h e   o r i g i n a l   l a n g u a g e   w h i c h   i n   t h i s   c a s e   l e a d s   t o   t h e   p o p   u p 
 l      ? 9 of the Select Lexical Forms dialog which we do not want.     r   o f   t h e   S e l e c t   L e x i c a l   F o r m s   d i a l o g   w h i c h   w e   d o   n o t   w a n t . 
 I   
 .prcskprsnull     ctxt
 m    	     w 
 
faal
 J   
  
 m   
 
 eMdsKcmd 
 m    
 eMdsKctl     
 O   	

	 I     0 
dodefdelay 
doDefDelay    

  f     
 I   (

 .prcskprsnull     ctxt

 m       v 
 
faal
 J     $ 
 m     !
 eMdsKcmd 
 m   ! "
 eMdsKctl     
 O  ) 3
 I   - 2 0 
dodefdelay 
doDefDelay    
  f   ) * 
 l  4 4       
 l  4 4     Enter and run the search       2   E n t e r   a n d   r u n   t h e   s e a r c h !"
! I  4 9#
 .prcskprsnull     ctxt
# o   4 5 0 	searchfor 	searchFor  " $%
$ O  : D&'
& I   > C 0 
dodefdelay 
doDefDelay    
'  f   : ;% ()
( I  E J*
 .prcskprsnull     ctxt
* o   E F
 
ret   ) +,
+ O  K V-.
- I   O U/ 0 dodelay doDelay/ 0
0 m   P Q     
.  f   K L, 12
1 l  W W      2 34
3 l  W W56  5   Get the analysis   6 77 "   G e t   t h e   a n a l y s i s4 89
8 l  W W:;  : L F cycle to the analysis tab assuming already open and set up correctly.   ; <<    c y c l e   t o   t h e   a n a l y s i s   t a b   a s s u m i n g   a l r e a d y   o p e n   a n d   s e t   u p   c o r r e c t l y .9 =>
= I  W a?@
 .prcskprsnull     ctxt
? m   W XAA BB  ]@ C
 
faal
C J   Y ]DD EF
E m   Y Z
 eMdsKcmdF G
G m   Z [
 eMdsKopt    > H
H O  b mIJ
I I   f lK 0 dodelay doDelayK L
L m   g h     
J  f   b c  
 o     0 
accordprocess 
accordProcess
 m     MM                                                                                  sevs  alis      Macintosh HD               +]H+  {.System Events.app                                              ~A`          	                CoreServices    +      A9    {.{.{.  =Macintosh HD:System: Library: CoreServices: System Events.app   $  S y s t e m   E v e n t s . a p p    M a c i n t o s h   H D  -System/Library/CoreServices/System Events.app   /    NO
N l  p p      O PQ
P l  p pRS  R   Get AS to save file   S TT (   G e t   A S   t o   s a v e   f i l eQ UV
U I   p vW 00 saveanalysistotempfile saveAnalysisToTempFileW X
X o   q r 0 
accordprocess 
accordProcess    V YZ
Y l  w w      Z [\
[ l  w w]^  ] = 7 cycle back to the search tab so the next search is ok.   ^ __ n   c y c l e   b a c k   t o   t h e   s e a r c h   t a b   s o   t h e   n e x t   s e a r c h   i s   o k .\ `a
` O   w bc
b O   { de
d I   fg
 .prcskprsnull     ctxt
f m    hh ii  [g j
 
faal
j J    kk lm
l m    
 eMdsKcmdm n
n m    
 eMdsKopt    
e o   { | 0 
accordprocess 
accordProcess
c m   w xoo                                                                                  sevs  alis      Macintosh HD               +]H+  {.System Events.app                                              ~A`          	                CoreServices    +      A9    {.{.{.  =Macintosh HD:System: Library: CoreServices: System Events.app   $  S y s t e m   E v e n t s . a p p    M a c i n t o s h   H D  -System/Library/CoreServices/System Events.app   /   a p
p I     0 
dodefdelay 
doDefDelay       qr
q l           r st
s l      uv  u  
 * Get the Accordance process name.
 * I suspect this is overkill for versions 10+ but will thin it out later
 *
 * Returns : the process name as a string
    v ww: 
   *   G e t   t h e   A c c o r d a n c e   p r o c e s s   n a m e . 
   *   I   s u s p e c t   t h i s   i s   o v e r k i l l   f o r   v e r s i o n s   1 0 +   b u t   w i l l   t h i n   i t   o u t   l a t e r 
   * 
   *   R e t u r n s   :   t h e   p r o c e s s   n a m e   a s   a   s t r i n g 
  t xy
x i   1 4z{
z I       0 getprocname getProcName    
{ O     -|}
| Q    ,~
~ L    

 4    
 
prcs
 m   	 
  
 a c o r d
 R      
 .ascrerr ****       ****    
 Q    ,
 L    
 4    
 
prcs
 m       A c c o r d
 R      
 .ascrerr ****       ****    
 L   & ,
 4   & +
 
prcs
 m   ( )   A c c o r d a n c e
} m                                                                                       sevs  alis      Macintosh HD               +]H+  {.System Events.app                                              ~A`          	                CoreServices    +      A9    {.{.{.  =Macintosh HD:System: Library: CoreServices: System Events.app   $  S y s t e m   E v e n t s . a p p    M a c i n t o s h   H D  -System/Library/CoreServices/System Events.app   /   y 
 l            
 l        /)
 * Do a standard length delay using the OS sleep command
 * This is done in the OS because the AS sleep bloats to
 * very large values when called within iterative structures.
 * I don't actually know why this is so but it is possible
 * to get 10second or higher sleeps when requesting just 1.
     R 
   *   D o   a   s t a n d a r d   l e n g t h   d e l a y   u s i n g   t h e   O S   s l e e p   c o m m a n d 
   *   T h i s   i s   d o n e   i n   t h e   O S   b e c a u s e   t h e   A S   s l e e p   b l o a t s   t o 
   *   v e r y   l a r g e   v a l u e s   w h e n   c a l l e d   w i t h i n   i t e r a t i v e   s t r u c t u r e s . 
   *   I   d o n ' t   a c t u a l l y   k n o w   w h y   t h i s   i s   s o   b u t   i t   i s   p o s s i b l e 
   *   t o   g e t   1 0 s e c o n d   o r   h i g h e r   s l e e p s   w h e n   r e q u e s t i n g   j u s t   1 . 
   
 i   5 8
 I       0 dodelay doDelay 
 o       0 delayt delayT    
 I    
 .sysoexecTEXT     TEXT
 l    
 b     
 m        s l e e p  
 o    ~~ 0 delayt delayT       
 l     }|{}  |  {   
 l      zz   3 -
 * Helper handler to do common short delay
      Z 
   *   H e l p e r   h a n d l e r   t o   d o   c o m m o n   s h o r t   d e l a y 
   
 i   9 <
 I      yxwy 0 
dodefdelay 
doDefDelayx  w  
 I     vuv 0 dodelay doDelay t
 m     ?      t  u   
 l     srqs  r  q   
 l      pp   3 -
 * Delete a file and confirm that its gone
      Z 
   *   D e l e t e   a   f i l e   a n d   c o n f i r m   t h a t   i t s   g o n e 
   
 i   = @
 I      ono 0 
deletefile 
deleteFile m
 o      ll 0 filename  m  n  
 k     n 
 Q     
 O    
 I   kj
k .coredeloobj        obj 
 4    i
i 
file
 o   	 
hh 0 filename  j  
 m                                                                                      MACS  alis    t  Macintosh HD               +]H+  {.
Finder.app                                                     }T_          	                CoreServices    +      `D    {.{.{.  6Macintosh HD:System: Library: CoreServices: Finder.app   
 F i n d e r . a p p    M a c i n t o s h   H D  &System/Library/CoreServices/Finder.app  /   
 R      gf
g .ascrerr ****       ****f   ed
e 
errn
 d      
 m      ccd  
 l   bb   < 6 ignore - file did not exist when delete was attempted     l   i g n o r e   -   f i l e   d i d   n o t   e x i s t   w h e n   d e l e t e   w a s   a t t e m p t e d 
 l   a`_a  `  _   
 l   ^^   !  now check the file is gone     6   n o w   c h e c k   t h e   f i l e   i s   g o n e 
 l   ]]   D > Note : do not do this from the tell above. There is something     |   N o t e   :   d o   n o t   d o   t h i s   f r o m   t h e   t e l l   a b o v e .   T h e r e   i s   s o m e t h i n g 
 l   \\   F @ unreliable about that and it reports the file gone when in fact        u n r e l i a b l e   a b o u t   t h a t   a n d   i t   r e p o r t s   t h e   f i l e   g o n e   w h e n   i n   f a c t 
 l   [[   &   the FS thinks its still around.     @   t h e   F S   t h i n k s   i t s   s t i l l   a r o u n d . Z
 Y    nYX
 k   $ i 
 O  $ 0
 r   ( /
 I  ( -WV
W .coredoexbool        obj 
 o   ( )UU 0 filename  V  
 o      TT 	0 found  
 m   $ %                                                                                  MACS  alis    t  Macintosh HD               +]H+  {.
Finder.app                                                     }T_          	                CoreServices    +      `D    {.{.{.  6Macintosh HD:System: Library: CoreServices: Finder.app   
 F i n d e r . a p p    M a c i n t o s h   H D  &System/Library/CoreServices/Finder.app  /    
 Z   1 BSR
 >  1 4
 o   1 2QQ 	0 found  
 m   2 3P
P boovtrue
 k   7 > 
 I  7 <ON
O .ascrcmnt****       ****
 m   7 8   F i l e   d e l e t e dN   M
  S   = >M  S  R    
  Z   C ]LK
 =   C F
 o   C DJJ 0 i  
 m   D EII 
 R   I YH
H .ascrerr ****       ****
 b   Q X	
 o   Q VGG 60 couldnotdeletefile_errmsg CouldNotDeleteFile_ErrMsg
	 o   V WFF 0 filename   E
D
E 
errn

 o   K PCC 60 couldnotdeletefile_errnum CouldNotDeleteFile_ErrNumD  L  K   
 I  ^ cB
A
B .ascrcmnt****       ****

 m   ^ _   N o t   g o n e   y e tA   @
 I   d i?>=? 0 
dodefdelay 
doDefDelay>  =  @  Y 0 i  
 m    << 
 m    ;; X  Z   
 l     :98:  9  8   
 l      77    
 * Save the analysis tab to a temporary file as txt.
 * It is assumed that we are currently focussed in the analysis tab.
 *   The caller must set this up.
     < 
   *   S a v e   t h e   a n a l y s i s   t a b   t o   a   t e m p o r a r y   f i l e   a s   t x t . 
   *   I t   i s   a s s u m e d   t h a t   w e   a r e   c u r r e n t l y   f o c u s s e d   i n   t h e   a n a l y s i s   t a b . 
   *       T h e   c a l l e r   m u s t   s e t   t h i s   u p . 
   
 i   A D
 I      656 00 saveanalysistotempfile saveAnalysisToTempFile 4
 o      33 0 
accordprocess 
accordProcess4  5  
 k       
 I     2!12 0 
deletefile 
deleteFile! "0
" c    #$
# l   %/.
% b    &'
& b    ()
( l   *-,
* I   ++*
+ .earsffdralis        afdr
+ m    )
) afdrtemp*  -  ,  
) o    (( ,0 analysistempfilename analysisTempFileName
' m    
,, --  . t x t/  .  
$ m    '
' 
ctxt0  1    .&
. O    /0
/ O    ~12
1 k     }33 45
4 I    7%6$
% .prcsclicnull  uiel
6 n     378
7 4   0 3#9
# 
menI
9 m   1 2:: ;;  P l a i n   T e x t &
8 n     0<=
< 4   - 0">
" 
menE
> m   . /!! 
= n     -?@
? 4   * - A
  
menI
A m   + ,BB CC " S a v e   A s   T e x t   F i l e
@ n     *DE
D 4   ' *F
 
menE
F m   ( ) 
E n     'GH
G 4   $ 'I
 
mbri
I m   % &JJ KK  F i l e
H 4     $L
 
mbar
L m   " # $  5 MN
M O  8 COP
O I   < BQ 0 dodelay doDelayQ R
R m   = >     
P  f   8 9N ST
S l  D DUV  U $  Go to the temporary directory   V WW <   G o   t o   t h e   t e m p o r a r y   d i r e c t o r yT XY
X I  D MZ
 .prcskprsnull     ctxt
Z l  D I[
[ I  D I\
 .earsffdralis        afdr
\ m   D E
 afdrtemp        Y ]^
] I  N U_
 .prcskprsnull     ctxt
_ o   N Q
 
ret 
  ^ `a
` O  V `bc
b I   Z _
	 0 
dodefdelay 
doDefDelay
  	  
c  f   V Wa de
d I  a jf
 .prcskprsnull     ctxt
f o   a f ,0 analysistempfilename analysisTempFileName  e gh
g I  k ri
 .prcskprsnull     ctxt
i o   k n
 
ret   h j
j O  s }kl
k I   w |  0 
dodefdelay 
doDefDelay     
l  f   s t  
2 4    m
 
prcs
m m    nn oo 
 a c o r d
0 m    pp                                                                                  sevs  alis      Macintosh HD               +]H+  {.System Events.app                                              ~A`          	                CoreServices    +      A9    {.{.{.  =Macintosh HD:System: Library: CoreServices: System Events.app   $  S y s t e m   E v e n t s . a p p    M a c i n t o s h   H D  -System/Library/CoreServices/System Events.app   /   &   qr
q l           r st
s l      uv  u  
 * Code to cleanup the captured string and produce a TSV format string which can be
 * imported on cram.com. Many of these routines need to move to accutils and
 * be generalized.
    v wwl 
   *   C o d e   t o   c l e a n u p   t h e   c a p t u r e d   s t r i n g   a n d   p r o d u c e   a   T S V   f o r m a t   s t r i n g   w h i c h   c a n   b e 
   *   i m p o r t e d   o n   c r a m . c o m .   M a n y   o f   t h e s e   r o u t i n e s   n e e d   t o   m o v e   t o   a c c u t i l s   a n d 
   *   b e   g e n e r a l i z e d . 
  t xy
x l      z{  z P J
 * Replace all occurrences of string search with string repl
 * in src.
    { ||  
   *   R e p l a c e   a l l   o c c u r r e n c e s   o f   s t r i n g   s e a r c h   w i t h   s t r i n g   r e p l 
   *   i n   s r c . 
  y }~
} i   E H
 I       0 replace   
 o       0 src   
 o       
0 search   
 o       0 repl      
 k      
 l            
 r     
 n     
 1    
 
leng
 o      
0 search  
 o       0 slen sLen 
 r    
 \    	
 o     0 slen sLen
 m     
 o       0 lastpos lastPos 
 r    
 I   
 .sysooffslong     null   
 
psof
 o     
0 search   
 
psin
 o     0 src    
 o       0 spos sPos 
 r    
 o     0 src  
 o       0 res   
 W    
 k   $  
 Z   $ |
 =   $ '
 o   $ % 0 spos sPos
 m   % & 
 r   * ;
 b   * 9
 o   * + 0 repl  
 n   + 8
 7 , 8
 
ctxt
 l  0 4
 [   0 4
 o   1 2 0 slen sLen
 m   2 3     
 m   5 7
 o   + , 0 res  
 o       0 res   
 =   > E
 o   > ? 0 spos sPos
 \   ? D
 l  ? B
 n   ? B
 1   @ B
 
leng
 o   ? @ 0 src      
 o   B C 0 lastpos lastPos 
 r   H Z
 b   H X
 n   H V
 7 I V
 
ctxt
 m   M O 
 d   P U
 l  Q T
 [   Q T
 o   Q R 0 slen sLen
 m   R S     
 o   H I 0 res  
 o   V W 0 repl  
 o       0 res    
 r   ] |
 b   ] z
 b   ] l
 n   ] j
 7 ^ j
 
ctxt
 m   b d 
 l  e i
 \   e i
 o   f g 0 spos sPos
 m   g h     
 o   ] ^ 0 res  
 o   j k 0 repl  
 n   l y
 7 m y
 
ctxt
 l  q u
 [   q u
 o   r s 0 spos sPos
 o   s t 0 slen sLen    
 m   v x
 o   l m 0 res  
 o       0 res   
 r   } 
 I  } 
 .sysooffslong     null   
 
psof
 o     
0 search   
 
psin
 o     0 res    
 o       0 spos sPos  
 =     #
 o     ! 0 spos sPos
 m   ! "   
 L    
 o     0 res    ~ 
 l            
 l         S M
 * Trim string from trimFrom string to the next carriage return
 * in src.
       
   *   T r i m   s t r i n g   f r o m   t r i m F r o m   s t r i n g   t o   t h e   n e x t   c a r r i a g e   r e t u r n 
   *   i n   s r c . 
   
 i   I L
 I       0 	trimright 	trimRight 
 o       0 src   
 o       0 trimfrom trimFrom    
 k       
 I    
 .ascrcmnt****       ****
 m        I n   t r i m R i g h t    
 r    
 n    		
 1    	
 
leng
	 o     0 trimfrom trimFrom
 o       0 tlen tLen 


 l   
   $  get src up to trimFrom string   
  <   g e t   s r c   u p   t o   t r i m F r o m   s t r i n g 
 r    
 I   
 .sysooffslong     null   
 
psof
 o     0 trimfrom trimFrom 
 
psin
 o     0 src    
 o       0 off   
 l      &   now iterate the string removing     @   n o w   i t e r a t e   t h e   s t r i n g   r e m o v i n g 
 l      - ' all occurrences of trimFrom until a CR       N   a l l   o c c u r r e n c e s   o f   t r i m F r o m   u n t i l   a   C R !"
! r    #$
# o     0 src  
$ o       0 res  " %&
% r    !'(
' n    )*
) 1    
 
leng
* o     0 res  
( o       0 reslen resLen& +,
+ W   " -.
- k   * // 01
0 r   * 723
2 n   * 545
4 7 + 567
 
ctxt
6 m   / 1 
7 o   2 4 0 off  
5 o   * + 0 res  
3 o       0 	firsthalf 	firstHalf1 89
8 r   8 G:;
: n   8 E<=
< 7 9 E>?
 
ctxt
> l  = A@
@ [   = AAB
A o   > ? 0 off  
B o   ? @ 0 tlen tLen    
? o   B D 0 reslen resLen
= o   8 9~~ 0 res  
; o      }} 
0 	remainder  9 CD
C r   H MEF
E n   H KGH
G 1   I K|
| 
leng
H o   H I{{ 
0 	remainder  
F o      zz 0 rlen rLenD IJ
I r   N YKL
K l  N WMyx
M I  N WwvN
w .sysooffslong     nullv  N uOP
u 
psof
O m   P QQQ RR  
P tSs
t 
psin
S o   R Srr 
0 	remainder  s  y  x  
L o      qq 0 eol  J TU
T r   Z gVW
V n   Z eXY
X 7 [ epZ[
p 
ctxt
Z o   _ aoo 0 eol  
[ o   b dnn 0 rlen rLen
Y o   Z [mm 
0 	remainder  
W o      ll 0 
secondhalf 
secondHalfU \]
\ r   h m^_
^ b   h k`a
` o   h ikk 0 	firsthalf 	firstHalf
a o   i jjj 0 
secondhalf 
secondHalf
_ o      ii 0 res  ] bc
b r   n sde
d n   n qfg
f 1   o qh
h 
leng
g o   n ogg 0 res  
e o      ff 0 reslen resLenc hi
h l  t tedce  d  c  i jk
j l  t tblmb  l 6 0 termination condition is when there are no more   m nn `   t e r m i n a t i o n   c o n d i t i o n   i s   w h e n   t h e r e   a r e   n o   m o r ek op
o l  t taqra  q 0 * occurrences of trimFrom in the src string   r ss T   o c c u r r e n c e s   o f   t r i m F r o m   i n   t h e   s r c   s t r i n gp t`
t r   t uv
u I  t }_^w
_ .sysooffslong     null^  w ]xy
] 
psof
x o   v w\\ 0 trimfrom trimFromy [zZ
[ 
psin
z o   x yYY 0 res  Z  
v o      XX 0 off  `  
. =   & ){|
{ o   & 'WW 0 off  
| m   ' (VV  , }U
} L    ~
~ o    TT 0 res  U   
 l     SRQS  R  Q   
 l      PP   h b
 * Replace groups of more than one \r with just one.
 * Make sure the end of the line has none.
       
   *   R e p l a c e   g r o u p s   o f   m o r e   t h a n   o n e   \ r   w i t h   j u s t   o n e . 
   *   M a k e   s u r e   t h e   e n d   o f   t h e   l i n e   h a s   n o n e . 
   
 i   M P
 I      ONO $0 removeblanklines removeBlankLines M
 o      LL 0 str  M  N  
 k     I 
 r     
 m        
 o      KK 0 res   
 r    
 m       
 o      JJ 0 cr   
 Y    FIH
 k    A 
 r    
 n    
 4    G
G 
cha 
 o    FF 0 i  
 o    EE 0 str  
 o      DD 0 c   C
 Z    AB
 >   
 o    AA 0 c  
 m       

 k   " ; 
 Z   " 5@?
 >  " %
 o   " #>> 0 cr  
 m   # $   
 k   ( 1 
 r   ( -
 b   ( +
 o   ( )== 0 res  
 o   ) *<< 0 cr  
 o      ;; 0 res   :
 r   . 1
 m   . /   
 o      99 0 cr  :  @  ?   8
 r   6 ;
 b   6 9
 o   6 777 0 res  
 o   7 866 0 c  
 o      55 0 res  8  B  
 r   > A
 o   > ?44 0 c  
 o      33 0 cr  C  I 0 i  
 m    22 
 n    
 1   
 1
1 
leng
 o    
00 0 str  H   /
 L   G I
 o   G H.. 0 res  /   
 l     -,+-  ,  +   
 l      **   @ :
 * Remove the first n lines, delimited by "\r" from str
      t 
   *   R e m o v e   t h e   f i r s t   n   l i n e s ,   d e l i m i t e d   b y   " \ r "   f r o m   s t r 
   
 i   Q T
 I      )() &0 removefirstnlines removeFirstNLines 
 o      '' 0 str   &
 o      %% 0 n  &  (  
 k     O 
 r     
 m     $$  
 o      ## 0 removeuntil removeUntil 
 r    	
 n    
 1    "
" 
leng
 o    !! 0 str  
 o         0 len   
 r   
 

 m   
  
 o       0 i   
 r    
 m      
 o       0 cnt   
 W    ?
 k    : 
 r     
 n    
 4    
 
cha 
 o     0 i  
 o     0 str  
 o       0 c   
 Z   ! 4
 =  ! $ 
  o   ! " 0 c  
 m   " #   

 k   ' 0 
 r   ' *
 o   ' ( 0 i  
 o       0 removeuntil removeUntil 	
	 r   + 0


 [   + .

 o   + , 0 cnt  

 m   , - 
 o       0 cnt         
 r   5 :
 [   5 8
 o   5 6

 0 i  
 m   6 7 
 o       0 i    
 =    
 o    

 0 cnt  
 o    		 0 n   
 L   @ O
 n   @ N
 7 A M
 
ctxt
 l  E I
 [   E I
 o   F G 0 removeuntil removeUntil
 m   G H     
 o   J L 0 len  
 o   @ A 0 str     
 l               !
  l      "#  " c ]
 * Convert the string in the temporary file to a TSV string removing
 * extraneous content
    # $$  
   *   C o n v e r t   t h e   s t r i n g   i n   t h e   t e m p o r a r y   f i l e   t o   a   T S V   s t r i n g   r e m o v i n g 
   *   e x t r a n e o u s   c o n t e n t 
  ! %&
% i   U X'(
' I      ) 0 converttotsv convertToTSV) *
* o       0 tmpfile      
( k     ++ ,-
, l           - ./
. l     01  0 !  Open file and read content   1 22 6   O p e n   f i l e   a n d   r e a d   c o n t e n t/ 34
3 r     56
5 I    7
 .rdwropenshor       file
7 o      0 tmpfile    
6 o       0 fh  4 89
8 Q    [:;<
: k    8== >?
> O   @A
@ r    BC
B n    DE
D 1    
 
ptsz
E 4    F
 
file
F o     0 tmpfile  
C o       0 sz  
A m    GG                                                                                  MACS  alis    t  Macintosh HD               +]H+  {.
Finder.app                                                     }T_          	                CoreServices    +      `D    {.{.{.  6Macintosh HD:System: Library: CoreServices: Finder.app   
 F i n d e r . a p p    M a c i n t o s h   H D  &System/Library/CoreServices/Finder.app  /   ? HI
H r    &JK
J I   $LM
 .rdwrread****        ****
L o     0 fh  M NO
 
rdfm
N m     O PQ
 
rdto
P o     0 sz  Q R
 
as  
R m     
 
utxt  
K o       0 str  I ST
S I  ' ,U
 .ascrcmnt****       ****
U m   ' (VV WW  r e a d   o k  T XY
X I  - 2Z
 .ascrcmnt****       ****
Z o   - . 0 str    Y [
[ I  3 8\
 .rdwrclosnull     ****
\ o   3 4 0 fh      
; R      ]^
 .ascrerr ****       ****
] o       0 errmsg errMsg^ _
 
errn
_ o       0 errnum errNum  
< k   @ [`` ab
a I  @ Ic
 .ascrcmnt****       ****
c b   @ Ede
d b   @ Cfg
f o   @ A 0 errmsg errMsg
g m   A Bhh ii   
e o   C D 0 errnum errNum  b jk
j I  J Ol
 .rdwrclosnull     ****
l o   J K 0 fh    k mn
m I  P Yo
 .ascrcmnt****       ****
o b   P Upq
p m   P Srr ss  G o t   e r r :  
q o   S T 0 errmsg errMsg  n t
t l  Z Zuv  u   error errMsg number errNum   v ww 4 e r r o r   e r r M s g   n u m b e r   e r r N u m  9 xy
x l  \ \      y z{
z l  \ \|}  |   Modify the string   } ~~ $   M o d i f y   t h e   s t r i n g{ 
 r   \ j
 I   \ h 0 replace   
 o   ] ^ 0 str   
 m   ^ a   	 	 
 m   a d       
 o       0 s1   
 r   k v
 I   k t 0 	trimright 	trimRight 
 o   l m 0 s1   
 m   m p     =    
 o       0 s2   
 r   w 
 I   w  0 replace   
 o   x y 0 s2   
 m   y |   	 ( 
 m   |      (    
 o       0 s3   
 r    
 I     0 replace   
 o     0 s3   
 m         ( + 
 m       	 ( +    
 o       0 s4   
 r    
 I     $0 removeblanklines removeBlankLines 
 o     0 s4      
 o       0 s5   
 r    
 I     &0 removefirstnlines removeFirstNLines 
 o     0 s5   
 m         
 o       0 s6   
 l          
 L    
 o     0 s6    & 
 l                   
   5 = E    *0 defaultsearchstring defaultSearchString ,0 analysistempfilename analysisTempFileName 0 d   .0 nosearchstring_errnum NoSearchString_ErrNum .0 nosearchstring_errmsg NoSearchString_ErrMsg .0 noflashcardsws_errnum NoFlashcardsWS_ErrNum .0 noflashcardsws_errmsg NoFlashcardsWS_ErrMsg 60 couldnotdeletefile_errnum CouldNotDeleteFile_ErrNum 60 couldnotdeletefile_errmsg CouldNotDeleteFile_ErrMsg
 .aevtoappnull      **** "0 getsearchstring getSearchString $0 createflashcards createFlashCards $0 findflashcardsws findFlashcardsWS *0 runaccordancesearch runAccordanceSearch 0 getprocname getProcName 0 dodelay doDelay 0 
dodefdelay 
doDefDelay 0 
deletefile 
deleteFile 00 saveanalysistotempfile saveAnalysisToTempFile 0 replace   0 	trimright 	trimRight $0 removeblanklines removeBlankLines &0 removefirstnlines removeFirstNLines 0 converttotsv convertToTSV  Q~}
 .aevtoappnull      ****  ~   |{| 0 errmsg errMsg{ 0 errnum errNum zy mxwvut s rqp   z "0 getsearchstring getSearchStringy 0 searchstring searchString
x .miscactvnull  nullw 0 getprocname getProcNamev $0 createflashcards createFlashCardsu 0 errmsg errMsg onm
o 
errnn 0 errnum errNumm  t
s 
appr
r .sysodlogaskr        TEXTqI
p 
errn} g*j+  EO  *j UO**j+ l+ OPW BX  ) *j UO  l Y "  )lY %a %%a l  l kjil "0 getsearchstring getSearchStringk  j   hgh 0 reqsearchstr reqSearchStrg 0 srch    fe dcb a `
f 
dtxt
e 
apprd 
c .sysodlogaskr        TEXT
b 
bhit
a 
ttxt
` 
errni >b    EO,  &,EO  )b  lb  Y hOY h _^]\_ $0 createflashcards createFlashCards^ [[   ZYZ 0 
accordprocess 
accordProcessY 0 	searchfor 	searchFor]   XWVUTSRX 0 
accordprocess 
accordProcessW 0 	searchfor 	searchForV 0 tsvstr tsvStrU 0 tsvfile tsvFileT 0 tf  S 0 errmsg errMsgR 0 errnum errNum QPONMLTKJI\HGFEDCBA@y{?>Q $0 findflashcardsws findFlashcardsWSP *0 runaccordancesearch runAccordanceSearchO 0 dodelay doDelay
N .miscactvnull  null
M afdrtemp
L .earsffdralis        afdr
K 
ctxtJ 0 converttotsv convertToTSV
I 
prmt
H .sysonwflfile     null
G 
perm
F .rdwropenshor       file
E 
refn
D 
as  
C 
utf8B 
A .rdwrwritnull     ****@ 0 errmsg errMsg =<;
= 
errn< 0 errnum errNum;  
? .ascrcmnt****       ****
> .rdwrclosnull     ****\ w*k+  O*l+ O*kk+ O)j O*j b  %%&k+ EO*l EOel 
EO a a  W X  a %a %%j Oj OP :987: $0 findflashcardsws findFlashcardsWS9 66   55 0 
accordprocess 
accordProcess8   43214 0 
accordprocess 
accordProcess3 0 fcards fCards2 0 errmsg errMsg1 0 errnum errNum 0/.-,+*)
0 
mbar
/ 
mbri
. 
menE
- 
menI
, .prcsclicnull  uiel+ 0 errmsg errMsg ('&
( 
errn' 0 errnum errNum&  *@
) 
errn7 M I D *k//k//EOj OhW &X  	  )b  lb  Y hO)lUU %$#"% *0 runaccordancesearch runAccordanceSearch$ !!      0 
accordprocess 
accordProcess 0 	searchfor 	searchFor#    0 
accordprocess 
accordProcess 0 	searchfor 	searchFor M Ah
 
faal
 eMdsKcmd
 eMdsKctl
 .prcskprsnull     ctxt 0 
dodefdelay 
doDefDelay
 
ret  0 dodelay doDelay
 eMdsKopt 00 saveanalysistotempfile saveAnalysisToTempFile"  l glvl O) *j+ UOlvl O) *j+ UOj O) *j+ UOj O) *lk+ 	UOlvl O) *kk+ 	UUUO*k+ O  lvl UUO*j+  { 0 getprocname getProcName       

 
prcs  
   . * */EW X   */EW 
X  */EU 
	 0 dodelay doDelay     0 delayt delayT
    0 delayt delayT 
 .sysoexecTEXT     TEXT	 %j   0 
dodefdelay 
doDefDelay          0 dodelay doDelay *k+   0 
deletefile 
deleteFile     0 filename      0 filename   0 i   	0 found   
 
file
 .coredeloobj        obj    
 
errn@   
 .coredoexbool        obj 
 .ascrcmnt****       ****
 
errn 0 
dodefdelay 
doDefDelay o  
*/j UW X  hO Skkh  	j EUOe j OY hO  )b  lb  %Y hOj O*j+ [OY  00 saveanalysistotempfile saveAnalysisToTempFile     0 
accordprocess 
accordProcess    0 
accordprocess 
accordProcess ,pnJB:
 afdrtemp
 .earsffdralis        afdr
 
ctxt 0 
deletefile 
deleteFile
 
prcs
 
mbar
 
mbri
 
menE
 
menI
 .prcsclicnull  uiel 0 dodelay doDelay
 .prcskprsnull     ctxt
 
ret  0 
dodefdelay 
doDefDelay *j b  %%&k+ O g*/ _*k//k//k//j O) *kk+ UOj j O_ j O) *j+ UOb  j O_ j O) *j+ UUU  0 replace       0 src   
0 search   0 repl      0 src   
0 search   0 repl   0 slen sLen 0 lastpos lastPos 0 spos sPos 0 res   
 
leng
 
psof
 
psin 
 .sysooffslong     null
 
ctxt ,EOkEO* EOEO phj k  [\[Zk\Zi2%EY @,  [\[Zk\Zk'2%EY ![\[Zk\Zk2%[\[Z\Zi2%EO* E[OYO  0 	trimright 	trimRight     0 src   0 trimfrom trimFrom    0 src   0 trimfrom trimFrom 0 tlen tLen 0 off   0 res   0 reslen resLen 0 	firsthalf 	firstHalf 
0 	remainder   0 rlen rLen 0 eol   0 
secondhalf 
secondHalf 	Q
 .ascrcmnt****       ****
 
leng
 
psof
 
psin 
 .sysooffslong     null
 
ctxt j O,EO* EOEO,EO ahj [\[Zk\Z2EO[\[Z\Z2EO,EO* EO[\[Z\Z2EO%EO,EO* E[OYO  $0 removeblanklines removeBlankLines     0 str      0 str   0 res   0 cr   0 i   0 c   
 
leng
 
cha  JEOEO =k,Ekh /EO  %EOEY hO%EY E[OYO  &0 removefirstnlines removeFirstNLines     0 str   0 n      0 str   0 n   0 removeuntil removeUntil 0 len   0 i   0 cnt   0 c   
 
leng
 
cha 
 
ctxt PjEO,EOkEOjEO ,h /EO  EOkEY hOkE[OYO[\[Zk\Z2E (  0 converttotsv convertToTSV     0 tmpfile      ~}|{zy 0 tmpfile   0 fh   0 sz   0 str   0 errmsg errMsg 0 errnum errNum~ 0 s1  } 0 s2  | 0 s3  { 0 s4  z 0 s5  y 0 s6   xGwvutsrqpVonmhrlkjih
x .rdwropenshor       file
w 
file
v 
ptsz
u 
rdfm
t 
rdto
s 
as  
r 
utxtq 
p .rdwrread****        ****
o .ascrcmnt****       ****
n .rdwrclosnull     ****m 0 errmsg errMsg gfe
g 
errnf 0 errnum errNume  l 0 replace  k 0 	trimright 	trimRightj $0 removeblanklines removeBlankLinesi h &0 removefirstnlines removeFirstNLines j  EO 2 
*/,EUOk 	EOj Oj Oj W "X 
 %%j Oj Oa %j OPO*a a m+ EO*a l+ EO*a a m+ EO*a a m+ EO*k+ EO*a l+ EO ascr  
ޭ